% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cog_stroke.r
\name{cog_stroke}
\alias{cog_stroke}
\title{Compute Stroke-Based Center of Gravity (COG)}
\usage{
cog_stroke(img, origin = c("bottomleft", "topleft"))
}
\arguments{
\item{img}{An image input, either a file path to an image file (e.g., PNG, JPEG),
or a \code{cimg} object from the \pkg{imager} package. The image should be in binary form,
with foreground (glyph) values not equal to 1 and background values equal to 1.}

\item{origin}{A character string indicating the location of the image origin.
Use \code{"bottomleft"} (default) if the y-axis increases upward (Cartesian),
or \code{"topleft"} if the y-axis increases downward (as in image arrays).}
}
\value{
A list containing:
\describe{
\item{\code{statistics}}{A data frame with the following components:
\itemize{
\item \code{center_x}, \code{center_y}: The (x, y) coordinates of the COG in pixel coordinates of the input image.
\item \code{center_x_trim}, \code{center_y_trim}: The COG coordinates relative to the trimmed glyph region, excluding image margins.
\item \code{center_x_std}, \code{center_y_std}: The standardized COG coordinates ranging from 0 to 1, based on the trimmed region's width and height.
\item \code{margin_left}, \code{margin_right}, \code{margin_top}, \code{margin_bottom}: Margins between the glyph and the image boundary.
\item \code{width_original}, \code{height_original}: Dimensions of the original image.
\item \code{width_trim}, \code{height_trim}: Width and height of the trimmed glyph region, excluding margins.
\item \code{area}: The number of pixels in the stroke region (i.e., the total mass used to compute the COG).
}
}
\item{\code{strokes}}{A data frame of (x, y) coordinates representing the stroke region (i.e., non-white pixels).}
}
}
\description{
Computes the center of gravity (COG) of a character-like binary image using its stroke region.
}
\details{
In the stroke-based method, the COG is defined as the arithmetic mean of the (x, y) coordinates
of all pixels that belong to the stroke region, i.e., the foreground pixels whose intensity values
are not equal to 1 (pure white). This approach assumes that each stroke pixel has unit mass and
contributes equally to the center calculation. The image is assumed to be binary, where the background
pixels have a value of 1, and all other pixels are treated as part of the glyph.

Mathematically, the stroke-based center of gravity \eqn{(G_x, G_y)} is defined as the weighted mean of pixel coordinates
within the stroke region, where each pixel contributes a value of 1 (unit mass) and background pixels are excluded.
Specifically, let \eqn{p(x, y)} be an indicator function such that \eqn{p(x, y) = 1} if the pixel \eqn{(x, y)}
belongs to the stroke region, and \eqn{p(x, y) = 0} otherwise. Then the horizontal and vertical components
of the COG are computed as:

\deqn{
  G_x = \frac{\sum_{x=1}^{w} \sum_{y=1}^{h} p(x, y)\, x}{\sum_{x=1}^{w} \sum_{y=1}^{h} p(x, y)}
}{
  Gx = (sum_{x=1..w} sum_{y=1..h} p(x,y)*x) / (sum_{x=1..w} sum_{y=1..h} p(x,y))
}
\deqn{
  G_y = \frac{\sum_{x=1}^{w} \sum_{y=1}^{h} p(x, y)\, y}{\sum_{x=1}^{w} \sum_{y=1}^{h} p(x, y)}
}{
  Gy = (sum_{x=1..w} sum_{y=1..h} p(x,y)*y) / (sum_{x=1..w} sum_{y=1..h} p(x,y))
}

where \eqn{w} and \eqn{h} denote the width and height of the image, respectively.
}
\examples{
data(img_A) # load example image from the package
result <- cog_stroke(img_A, origin = "bottomleft")

result$statistics # summary data frame
head(result$strokes) # stroke pixel coordinates
result$origin # image origin specification

}
