% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{mcov}
\alias{mcov}
\title{Matrix-variate covariance matrix}
\usage{
mcov(Y, use = "everything")
}
\arguments{
\item{Y}{a numeric n*p1*p2 data array corresponding to n data matrices 
of dimension p1*p2.}

\item{use}{a character string giving method for dealing with missing 
values, fed to the \code{\link[stats]{cov}} function.}
}
\value{
a p1*p2 by p1*p2 sample covariance matrix of the n vectorized data
matrices.
}
\description{
Compute the covariance matrix of a sample of data matrices.
}
\examples{
p1<-4 ; p2<-3 ; n<-200

# create a matrix Y with separable covariance
Sig1<-rWishart(1,p1,diag(p1))[,,1] 
Sig2<-rWishart(1,p2,diag(p2))[,,1] 

Y<-array(rnorm(n*p1*p2),dim=c(n,p1,p2))  
Y<-aperm( apply(Y,c(1,3),function(y){ msqrt(Sig1)\%*\%y } ),c(2,1,3)) 
Y<-aperm( apply(Y,c(1,2),function(y){ msqrt(Sig2)\%*\%y } ),c(2,3,1)) 

# covariance 
S<-mcov(Y) 
image(S)     

plot(S,kronecker(Sig2,Sig1)) ; abline(0,1) 

}
\author{
Peter Hoff
}
