% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descsuppR-package.r
\name{testWrapper}
\alias{testWrapper}
\title{Collect Warnings From Runnning testfun}
\usage{
testWrapper(testfun, values, grouping, ignore_test_errors = FALSE, ...)
}
\arguments{
\item{testfun}{character or function.  Which function to call.}

\item{values}{vector.  The values to compare (age, toxicity score, gene expression, ...)}

\item{grouping}{vector of the same length as values.  treated as factor giving the
group membership}

\item{ignore_test_errors}{logical. If \code{TRUE} returns an empty test results (as list).}

\item{...}{additional parameters.  are passed on to the testfun}
}
\value{
list.  the results from testfun plus the element 'warnings'
        containing all warnings collected from the run of testfun.
        the results from testfun are assumed to be of type list and
        are additionally assumed to contain at least the elements 'p.value'
        and 'method'.
}
\description{
wrap this around 'correlation' tests to get output formatted for buildDescrTbl
}
\details{
This function is called by buildDescrTbl in order to generate the
comparison p values.  Basically it just calls the provided testfun.
Main purpose is, that it collects warnings and returns them as well.
}
\author{
Andreas Leha
}
