% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsffq_simple_functions.R
\name{grams}
\alias{grams}
\title{Grams}
\usage{
grams(row)
}
\arguments{
\item{row}{A numeric vector with components 'age', representing the age of the
participant, and 'f1' to 'f85', representing different frequency factor responses
from the hsffq.}
}
\value{
A numeric vector of length 85, representing the estimated total daily
grams of each food consumed for the participant.
}
\description{
The grams function takes the age of a participant and their responses on the
hsffq to generate an estimate of the participant's total daily grams consumed
for each food.
}
\examples{

random_integers <- sample(1:9, 85, replace=TRUE)
vec <- c(6.2, random_integers)
grams(vec)

rquestionnaire <- function(n, n_food_questions = 85) {
  mat <- matrix(
    sample(1:9, n_food_questions*n, replace = TRUE),
    nrow = n, ncol = n_food_questions
  )
  df <- data.frame( age = round(runif(n, 2, 11), digits = 1) )
  cbind(df, as.data.frame(mat))
}
df <- rquestionnaire(2)

df_results <- data.frame()
for (i in 1:nrow(df)) {
  result <- grams(df[i,])
  df_results <- rbind(df_results, result)
}


}
