% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphviz-spec.R
\name{graphviz_spec_from_matrix}
\alias{graphviz_spec_from_matrix}
\title{Create a \code{graphviz} specification from a function matrix}
\usage{
graphviz_spec_from_matrix(funmat)
}
\arguments{
\item{funmat}{A function matrix generated by \code{\link[=foodweb_matrix]{foodweb_matrix()}}.}
}
\value{
A text string.
}
\description{
Given a function matrix created by \code{\link[=foodweb_matrix]{foodweb_matrix()}}, convert it into a text specification
that can be passed to \code{\link[DiagrammeR:grViz]{DiagrammeR::grViz()}}.
}
\examples{

fm <- matrix(c(0, 1, 1, 1, 0, 1, 0, 1, 0), nrow = 3)
colnames(fm) <- rownames(fm) <- c("foo", "bar", "baz")
graphviz_spec_from_matrix(fm)
}
\seealso{
\href{https://graphviz.org/}{graphviz.org/}
}
