% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_id.R
\name{id_adj_name}
\alias{id_adj_name}
\title{Match by confidence levels}
\usage{
id_adj_name(rate, conf = NULL, fid, sid, lsize = 6)
}
\arguments{
\item{rate}{ID rate vector.}

\item{conf}{Confidence levels for the id rate vector. Default to be NULL.}

\item{fid}{Mapping confidence levels from filler id.}

\item{sid}{To-be-matched confidence levels for suspect id. Must have equal length as fid.}

\item{lsize}{Lineup size. Defaults to 6.}
}
\value{
Adjusted ID vector.
}
\description{
A function to adjust the id rates for ca lineups using the 1/(lineup size) method;
match and adjust id rates by names of confidence levels for both filler and suspect ids.
}
\examples{
ca_id <- c(rep(0,3), rep(c(0.1, 0.15, 0.25), 2))
names(ca_id) <- paste0(rep(c("IDS", "IDF", "REJ"), each = 3), c("high", "medium", "low"))

fid_conf <- paste0("IDF", c("high", "medium", "low"))
sid_conf <- paste0("IDS", c("high", "medium", "low"))

id_adj_name(ca_id, fid = fid_conf, sid = sid_conf)
}
