% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bookcap_bib.R
\name{bookcap_bib}
\alias{bookcap_bib}
\title{Function to prepare metadata from book chapters for automatic insertion into scientific articles}
\usage{
bookcap_bib(input_date, input_tam)
}
\arguments{
\item{input_date}{is a dataframe with the scientific production database in the form of a book chapters}

\item{input_tam}{is the length of the dataframe with the main scientifics articles, obtained using package bibliorefer.}
}
\value{
The output of the bookcap_bib function is the file with the .bib extension, of the book chapters in BibTex format, prepared to be automatically included in the reference list of a scientific article.
}
\description{
The bookcap_bib function prepares the metadata of book chapters to be automatically included in a scientific article. The bookcap_bib function internally calls two support functions. The output of the bookcap_bib function is the file with the .bib extension, of the book chapters in BibTex format, prepared to be automatically included in the reference list of a scientific article.
}
\examples{

# Example

# File of database
file_db <- system.file("extdata","bookcap.csv", package = "gerefer")
separator <- ";"

# Parameters of the function
input_date <- example_database(file_db, separator)
input_tam <- 10

#Calls the function bookcap_bib
bookcaplister_bibtex <- bookcap_bib(input_date, input_tam)
bookcaplister_bibtex


}
\references{
1 - Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier.
2 - Bibliometric indicators to evaluate scientific activity. C García-Villar, J M García-Santos. Radiologia (Engl Ed). 2021 May-Jun;63(3):228-235.
}
