% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{gamma_est}
\alias{gamma_est}
\title{Maximum-likelihood estimation of parameters for the gamma distribution}
\usage{
gamma_est(data)
}
\arguments{
\item{data}{vector of positive valued observations}
}
\value{
returns a bivariate vector containing (\code{shape},\code{scale}) estimated parameter vector.
}
\description{
The maximum-likelihood estimators for the \code{shape} and \code{scale} parameters of a gamma distribution are computed due to the method of Bhattacharya (2001).
}
\examples{
gamma_est(stats::rgamma(100,shape=3,scale=6))

}
\references{
Bhattacharya, B. (2001) "Testing equality of scale parameters against restricted alternatives for \eqn{m \ge 3} gamma distributions with unknown common shape parameter". Journal of Statistical Computation and Simulations, 69(4):353-368, \href{https://doi.org/10.1080/00949650108812100}{DOI}
}
