% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mmatrix-colMeans.r,
%   R/method-mmatrix-colSums.r, R/method-mmatrix-rowMeans.r,
%   R/method-mmatrix-rowSums.r
\name{colMeans,mmatrix-method}
\alias{colMeans,mmatrix-method}
\alias{colSums,mmatrix-method}
\alias{rowMeans,mmatrix-method}
\alias{rowSums,mmatrix-method}
\title{Row and Columns sums and means}
\usage{
\S4method{colMeans}{mmatrix}(x, output.type)

\S4method{colSums}{mmatrix}(x, output.type)

\S4method{rowMeans}{mmatrix}(x, output.type)

\S4method{rowSums}{mmatrix}(x, output.type)
}
\arguments{
\item{x}{a dual matrix or array}

\item{output.type}{type of the result, if it's a mvector (see details)}
}
\value{
a mvector or a R vector, depending on the size of the result.
}
\description{
Methods generalizing the base methods to mmatrix objects
}
\details{
If the size of the result is greater
than \code{houba(max.size)}, then it will be a mvector instead of R object.
In this case its type will be determined using 'output.type'. If 'output.type'
is missing, a coherent choice will be made (integer or double).
}
\examples{
a <- matrix(1:20, 4, 5)
A <- as.mmatrix(a, "float")
colMeans(A)
rowSums(A)

}
