% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wareki_kyureki.R
\name{wareki2kyureki}
\alias{wareki2kyureki}
\alias{kyureki2wareki}
\title{wareki2kyureki}
\usage{
wareki2kyureki(
  date,
  era = c("south", "north", "east", "heishi", "kyoto", "non"),
  one = c("kanji", "number"),
  leap.month = c("kanji", "hiragana"),
  sep = c("kanji", "/", "-")
)

kyureki2wareki(
  date,
  era = c("south", "north", "east", "heishi", "kyoto", "non"),
  one = c("kanji", "number"),
  leap.month = c("kanji", "hiragana"),
  sep = c("kanji", "/", "-")
)
}
\arguments{
\item{date}{Date to be converted. It should always include the year, month, and day.}

\item{era}{Whether the Gengo of the Japanese calendar is the Southern or Northern dynasty system, the system used in the Kanto region, the Heike, and Kyoto respectively, or no era names.}

\item{one}{Whether to write the year in kanji as the first year or leave it as a number.}

\item{leap.month}{Whether to write leap months in Kanji or Hiragana.}

\item{sep}{The way the date is separated when the last date is written.}
}
\value{
String type date.
}
\description{
A set of functions for mutual conversion between Kyureki that the old Japanese calendar and Wareki that the current Japanese calendar. For years before 1872, Kyureki and Wareki are identical. After 1873, the Gregorian calendar was adopted in Japan, and there is a difference from there.
}
\examples{
wareki2kyureki("\u4ee4\u548c3\u5e741\u67081\u65e5")
kyureki2wareki("\u4ee4\u548c2\u5e7411\u670818\u65e5")

}
\references{
The data for the Kyureki calendar and era names refer to the following data.

manakai/data-locale \url{https://github.com/manakai/data-locale}
}
