% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{integrate_spd}
\alias{integrate_spd}
\title{Integration with respect to symmetric positive definite matrices}
\usage{
integrate_spd(
  f,
  dim,
  tol = 0.001,
  lb = 1e-08,
  ub = Inf,
  neval = 1000000L,
  method = c("suave", "hcubature"),
  ...
)
}
\arguments{
\item{f}{function to evaluate that takes as arguments array of size \code{dim} by \code{dim} by 1.}

\item{dim}{dimension of integral, only two or three dimensions are supported}

\item{tol}{double for tolerance of numerical integral}

\item{lb}{lower bound for integration range of eigenvalues}

\item{ub}{upper bound for integration range of eigenvalues}

\item{neval}{maximum number of evaluations}

\item{method}{string indicating the method from \code{cubature}}

\item{...}{additional arguments for the function \code{f}}
}
\value{
list returned by the integration routine. See the documentation of \link[cubature]{cubintegrate} for more details.
}
\description{
Given a function \code{f} defined over the space of symmetric positive definite matrices, compute an integral via numerical integration using the routine \link[cubature]{cubintegrate}.
}
\examples{
integrate_spd(
  dim = 2L,
  neval = 1e4L,
  f = function(x, S){
   dWishart(x, df = 10, S = S, log = FALSE)},
  S = diag(2))
}
