#' @title muckrock: a data package for the Freedom of Information Act
#'
#' @description \code{muckrock} is a data package containing metadata associated with
#' US Freedom Of Information Act (FOIA) requests, as aggregated and released by the
#' \href{https://www.muckrock.com/}{MuckRock project}.
#'
#' @details the package's contents are:
#' \describe{
#'    \item{\code{\link{agency_metadata}}}{Information about agencies that requests
#'    have been submitted to.}
#'    \item{\code{\link{jurisdiction_metadata}}}{Information about jurisdictions covered
#'    by MuckRock's scope.}
#'    \item{\code{\link{request_metadata}}}{Metadata associated with the actual FOIA
#'    requests.}
#' }
#' @docType package
#' @name muckrock
NULL