% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E_pois.R
\name{E_pois}
\alias{E_pois}
\title{Expected Value for One-Inflated Poisson Distribution}
\usage{
E_pois(b, g, X, Z)
}
\arguments{
\item{b}{Numeric vector of coefficients for the main Poisson model.}

\item{g}{Numeric vector of coefficients for the one-inflation process.}

\item{X}{Matrix of predictors for the main Poisson model, where rows correspond 
to observations and columns to covariates.}

\item{Z}{Matrix of predictors for the one-inflation process, structured similarly to `X`.}
}
\value{
A numeric vector of expected values for each observation in the dataset.
}
\description{
Computes the expected value from a one-inflated Poisson (OIPP) distribution 
based on the model parameters and covariates.
}
\seealso{
\code{\link{dEdq_pois}} for computing partial derivatives of expected values in the OIPP model.
}
\keyword{internal}
