% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phi_delta.R
\name{phiDelta.stats}
\alias{phiDelta.stats}
\title{Phi delta statistics from dataframe}
\usage{
phiDelta.stats(data, labels, ratio_corrected = TRUE)
}
\arguments{
\item{data}{dataframe without labels}

\item{labels}{vector of labels}

\item{ratio_corrected}{locigal, if true phi and delta will be calculated in respect to the ratio
of positive and negative samples}
}
\value{
dataframe, first column are the names of the features
second column the phi values
third column the delta values
}
\description{
calculates phi, delta and the ratio directly from the dataframe
with provided information and generates a list with the names of the features,
their phi and delta value and the ratio
}
\examples{
x <- climate_data
phiDelta <- phiDelta.stats(x[,-1],x[,1], ratio_corrected = FALSE)
with_ratio <- phiDelta.stats(x[,-1],x[,1])
}
\author{
rothe
}
