% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel.R
\name{saveBSM}
\alias{saveBSM}
\title{Save Symmetric Matrix to Binary}
\usage{
saveBSM(pfx, x, ltr = TRUE, diag = TRUE, unit = 4L, fid = ".")
}
\arguments{
\item{pfx}{prefix of output files}

\item{x}{symmetric matrix to save}

\item{ltr}{store the lower triangle only? (def=TRUE)}

\item{diag}{save diagnal? (def=TRUE) ignored if \code{ltr} is FALSE.}

\item{unit}{numerical unit, (def=4, single precision)}

\item{fid}{separator between FID and IID (def=".").}
}
\description{
Save symmetric matrix  to a binary core  file (.bin), and a text  file of IDs
(.id), recognizable by PLINK.
}
\examples{
pfx <- file.path(system.file("extdata", package="plinkFile"), "m20.rel")
rel <- readBSM(pfx)  # relatedness kernel matrix
re2 <- rel^2         # 2nd order polynomial kernel

tmp <- tempdir()
dir.create(tmp, FALSE)
out <- file.path(tmp, 'm20.re2')
saveBSM(out, re2)    # save the polynomial kernel
dir(tmp)             # show new files, then clean up
unlink(tmp, recursive=TRUE)

}
