% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interprofile.R
\name{interprofile}
\alias{interprofile}
\title{Draw a Posterior Interaction Profile in either style}
\usage{
interprofile(style = c("fountain", "waterfall"), ...)
}
\arguments{
\item{style}{Character string choosing the layout.  Accepts \code{"fountain"}
(default) or \code{"waterfall"}.  Matching is case-insensitive and only the
first few letters are required (e.g., \code{"wat"}).}

\item{...}{Further arguments passed on to either \code{pip_fountain()} or
\code{pip_waterfall()}.  See those functions for a full description of valid
parameters.}
}
\value{
Whatever the chosen PIP function returns: a \code{patchwork} object that
combines the two \code{ggplot2} panels, invisibly returned after being printed.
}
\description{
Convenience wrapper that calls \strong{\code{\link[=pip_fountain]{pip_fountain()}}} (default) or
\strong{\code{\link[=pip_waterfall]{pip_waterfall()}}} depending on the \code{style} argument.  All additional
arguments are forwarded unchanged to the selected function, so you can pass
\code{alpha}, \code{beta}, \code{distance_mat}, HDI bounds, grouping factors, and so on in
exactly the same way as you would when calling the underlying plotting
functions directly.
}
\examples{
# Small simulated example -----------------------------------------
set.seed(42)
N <- 6; I <- 10
alpha <- rnorm(N)
beta  <- rnorm(I, sd = 0.7)
dist  <- abs(matrix(rnorm(N * I, sd = 0.8), N, I))  # fake distances

# pip_profile() defaults to the fountain view
interprofile(alpha = alpha,
            beta  = beta,
            distance_mat = dist,
            focal_id = 2)

# Switch to waterfall with the same data
interprofile("waterfall",
            alpha = alpha,
            beta  = beta,
            distance_mat = dist,
            item_group = rep(LETTERS[1:2], length.out = length(beta)),
            y_limits=c(-3,2))

}
\seealso{
\itemize{
\item \code{\link[=pip_fountain]{pip_fountain()}} - "base at \eqn{-\beta}{-beta}, arrow up" style
\item \code{\link[=pip_waterfall]{pip_waterfall()}} - "base at \eqn{\beta}{beta}, arrow down" style
}
}
