% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjacency.R
\name{adjacency}
\alias{adjacency}
\title{Compute the Adjacency Matrix for a vector of preferences}
\usage{
adjacency(x, preferences_col = NULL, frequency_col = NULL, ...)
}
\arguments{
\item{x}{A \code{\link{preferences}} object or a \code{tibble} with a
\code{preferences}-typed column.}

\item{preferences_col}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> When \code{x} is a
\code{tibble}, the column containing the preferences.}

\item{frequency_col}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> When \code{x} is a
\code{tibble}, the column containing the frequency of the preferences. If not
provided, each row is considered to be observed a single time.}

\item{...}{Currently unused.}
}
\value{
An \eqn{N} by \eqn{N} matrix, where \eqn{N} is the number of
items.
}
\description{
Convert a set of preferences to an adjacency matrix summarising wins
and losses between pairs of items.
}
\details{
For a \code{preferences} object with \eqn{N} items, the adjacency
matrix is an \eqn{N} by \eqn{N} matrix, with element \eqn{(i, j)} being the
number of times item \eqn{i} wins over item \eqn{j}. For example, in the
preferences \{1\} > \{3, 4\} > \{2\}, item 1 wins over items 2, 3, and 4,
while items 3 and 4 win over item 2.

If \code{weights} is specified, the values in the adjacency matrix are the
weighted counts.
}
\examples{
x <- tibble::tribble(
  ~voter_id, ~species, ~food, ~ranking,
  1, "Rabbit", "Apple", 1,
  1, "Rabbit", "Banana", 2,
  1, "Rabbit", "Carrot", 3,
  2, "Monkey", "Banana", 1,
  2, "Monkey", "Apple", 2,
  2, "Monkey", "Carrot", 3
) |>
  long_preferences(
    food_preference,
    id_cols = voter_id,
    item_col = food,
    rank_col = ranking
  ) |>
  dplyr::pull(food_preference) |>
  adjacency()

}
