% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sim.lif.R
\name{sim.lif}
\alias{sim.lif}
\title{Simulate optogenetic stimulation on a leaky-integrate-fire neuron}
\usage{
sim.lif(n, I, C, R, Vth = 1, V0 = 0, bin = 5, dt = 0.05)
}
\arguments{
\item{n}{Number of time bins. The total time is \code{n} times \code{bin}.}

\item{I}{Input stimulus vector of  length \code{n}.}

\item{C}{Membrane capacitance of the simulated neuron.}

\item{R}{Membrane resistance  of the simulated neuron.}

\item{Vth}{Membrane potential threshold for spiking.}

\item{V0}{Membrane potential reset value after spiking.}

\item{bin}{Time length for each time bin. Default 5 millisecond.}

\item{dt}{Time length for each simulation step. Default 0.05 millisecond.}
}
\value{
a \code{list} of simulated neural spikes, optogenetic light flashes,  and simulation parameters.
}
\description{
Simulate various kinds of neural measures (e.g. membrane potentials and spikes) from a LIF neuron.
}
\examples{
n<- 500
set.seed(100)
re <- sim.lif(n, rbinom(n, 1, 0.14), 7, 3)
}

