% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2stl.R
\name{r2stl}
\alias{r2stl}
\title{Save R data to an STL file}
\usage{
r2stl(
  x,
  y,
  z,
  filename = "3d-R-object.stl",
  object.name = "r2stl-object",
  z.expand = FALSE,
  min.height = 0.008,
  show.persp = FALSE,
  strict.stl = FALSE
)
}
\arguments{
\item{x}{A numeric vector with the x-coordinates to plot.}

\item{y}{A numeric vector with the y-coordinates to plot.}

\item{z}{A numeric \code{length(x)} by \code{length(y)} matrix with the z-coordinates
to plot.}

\item{filename}{The STL filename.}

\item{object.name}{The object that is being described must have a name
specified inside the file. There's probably no point changing it from the
default.}

\item{z.expand}{To force the 3D plot to touch all six faces of the imaginary
cube that surrounds it, set this argument to \code{TRUE}.}

\item{min.height}{The minimum height for the printed material.}

\item{show.persp}{If set to \code{TRUE} then a \code{\link[graphics:persp]{persp}} plot of
this object is shown on the screen.}

\item{strict.stl}{If set to \code{TRUE} it makes files smaller but isn't
strictly proper STL format.}
}
\value{
The object returned when \code{\link[=connections]{close}} is used to close the
connection to \code{filename}.
}
\description{
\code{r2stl} takes numeric input exactly as with the \code{\link[graphics:persp]{persp}}
function. The output is a STL (stereolithography) file.
}
\details{
To view and test the STL files before printing them can be done
with many programs, for example an open-source option is Meshlab
\url{https://www.meshlab.net/}.
}
\examples{
# Let's do the classic persp() demo plot
x <- seq(-10, 10, length = 100)
y <- x
f <- function(x,y) {
  r <- sqrt(x^2+y^2)
  return(10 * sin(r) / r)
}
z <- outer(x, y, f)
z[is.na(z)] <- 1
file1 <- tempfile(fileext = ".stl")
r2stl(x, y, z, filename = file1, show.persp = TRUE)

# Now let's look at R's Volcano data
z <- volcano
x <- 1:dim(volcano)[1]
y <- 1:dim(volcano)[2]
file2 <- tempfile(fileext = ".stl")
r2stl(x, y, z, filename = file2, show.persp = TRUE)
}
\author{
Ian Walker.
}
