% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc.roclearn.R
\name{auc.roclearn}
\alias{auc.roclearn}
\title{Compute AUC for a fitted linear model}
\usage{
\method{auc}{roclearn}(object, newdata, y, ...)
}
\arguments{
\item{object}{A fitted model object of class \code{"roclearn"} (linear model).}

\item{newdata}{A matrix or data.frame of test predictors. Must have the same
structure as the training data (categorical variables are dummy-aligned
automatically).}

\item{y}{Response vector of test labels (\{-1, 1\} or convertible).}

\item{...}{Not used.}
}
\value{
A numeric scalar giving the estimated AUC.
}
\description{
Estimate the AUC (Area Under the ROC Curve) for a fitted linear model on new data.
}
\examples{
set.seed(123)

n_train <- 100
n_pos <- round(0.2 * n_train)
n_neg <- n_train - n_pos

X_train <- rbind(
  matrix(rnorm(2 * n_neg, mean = -1), ncol = 2),
  matrix(rnorm(2 * n_pos, mean =  1), ncol = 2)
)
y_train <- c(rep(-1, n_neg), rep(1, n_pos))

n_test <- 10
n_pos_test <- round(0.2 * n_test)
n_neg_test <- n_test - n_pos_test

X_test <- rbind(
  matrix(rnorm(2 * n_neg_test, mean = -1), ncol = 2),
  matrix(rnorm(2 * n_pos_test, mean =  1), ncol = 2)
)
y_test <- c(rep(-1, n_neg_test), rep(1, n_pos_test))

fit <- roclearn(X_train, y_train, lambda = 0.1, approx=TRUE)

auc(fit, X_test, y_test)
}
