% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graduate_qx.R
\name{graduate_qx}
\alias{graduate_qx}
\title{Graduates raw death probabilities}
\usage{
graduate_qx(
  x,
  ages,
  df = max(5, round(range(ages)/5)),
  threshold = 75,
  size = 10,
  omega = 120,
  zero2NA = 0,
  max.c.NA = 3,
  plot.explore = FALSE,
  ...
)
}
\arguments{
\item{x}{A list that is either an output of the `dw_crude_mx` or `tw_crude_mx` functions, or a list containing similar `qx`, `Lx` and `dx` components as the outputs of these functions. It is assumed that the first dimension of the matrices/arrays in `x` corresponds to age. Likewise, as happens with `dw_crude_mx` or `tw_crude_mx` is assumed that ages are ordered sequentially.}

\item{ages}{A vector of two components of non-negative integers indicating the minimum and maximum ages of the matrices in `x`.}

\item{df}{A non-negative integer indicating the number of degrees of freedom to be used in the natural splines. Default, the greater between 5 and the range of `ages` divided by 5. It is recommended to test several values for `df` if the smooth does not look appropriate.}

\item{threshold}{A non-negative integer indicating the minimum age from which start to explore whether unexpected decreases in mortality trends are observed. Default, 75.}

\item{size}{A non-negative integer indicating the sample size to be used for modelling (default is 10). No modelling is performed for a series of estimates if, after determining the effective threshold, the number of available observations is insufficient.}

\item{omega}{A non-negative integer indicating the initial maximum age up to which death probabilities are to be extended. By default, this is set to the maximum between `omega` (default value 120) and the maximum age in `x`.}

\item{zero2NA}{A nonnegative number to be used as a threshold for excluding particularly small raw estimated death probabilities. Default, `0`.}

\item{max.c.NA}{A nonnegative number informing about the maximum consequetive NA allowed in the range selected for smoothing. Default, `3`.}

\item{plot.explore}{A TRUE/FALSE argument indicating whether exploratory figures with the outputs should be plotted as a side-effect. Default, `FALSE`.}

\item{...}{Additional parameters to be passed to the `ns` function, from the `spline` package, as this is function is used to smooth the raw probabilities.}
}
\value{
A list with three components (qx.raw, qx.smooth, qx.final) with the same dimensions than qx. The first component (qx.raw) contains the introduced raw death probabilities. The second component (qx.smooth) contains the smoothed death probabilities obtained after applying the natural splines. The third (qx.final) component contains the final smoothed death probabilities attained after modelling, when possible and required.
}
\description{
This function graduates raw death probabilities using the two-step
             approach proposed by Sifre-Armengol et al. (2024). The method
             involves (i) applying natural cubic splines to smooth the
             log-transformation of the raw
             estimates, and (ii) correcting unexpected decreases in mortality
             trends at the oldest ages by modelling and extending death
             probability estimates up to a higher maximum age (omega). The function accepts
             as main input either an output from  `dw_crude_mx` or `tw_crude_mx`, or
             a list with containing similar `qx`, `Lx` and `dx` components.
}
\note{
When a set of final smoothed estimates cannot be obtained due to unsuccessful modeling, all corresponding values within the output component qx.final are set to `NA`.
}
\examples{

qx <- matrix(c(0.00053, 1e-04, 0.00013, 1e-04, 9e-05, 6e-05, 4e-05, 3e-05,
               4e-05, 9e-05, 8e-05, 0.00017, 0.00025, 0.00031, 0.00029,
               0.00034, 0.00035, 0.00035, 0.00036, 0.00034, 0.00035, 0.00034,
               0.00037, 0.00037, 0.00045, 0.00048, 5e-04, 0.00056, 0.00068,
               1e-04, 0.00073, 0.00077, 0.00073, 0.00074, 0.00081, 0.00086,
               0.00099, 0.00107, 0.00111, 0.00116, 0.00122, 0.00142, 0.00167,
               0.00197, 0.00235, 0.00282, 0.00305, 0.00327, 0.00357, 0.0039,
               0.00438, 0.00481, 0.00571, 0.00615, 0.00676, 0.00728, 0.00787,
               0.00839, 0.0094, 0.01044, 0.01119, 0.01231, 0.01336, 0.01456,
               0.01551, 0.0168, 0.01834, 0.02012, 0.0214, 0.02341, 0.02565,
               0.02744, 0.02995, 0.03275, 0.03604, 0.04027, 0.04617, 0.05092,
               0.05793, 0.06425, 0.07136, 0.07907, 0.0878, 0.09703, 0.10735,
               0.11913, 0.13115, 0.14478, 0.15927, 0.17506, 0.19133, 0.20803,
               0.22459, 0.23739, 0.25289, 0.26508, 0.26514, 0.27186, 0.28433,
               0.27071, 0.23445, 0.20622, 0.17334, 0.13063, 0.12384, 0.1298,
               0.14223, 0.10746, 0.1071, 0.09006, 0.08212, 0.00044, 0.00015,
               0.00011, 0.00014, 0.00011, 6e-05, 3e-05, 4e-05, 5e-05, 0.00011,
               1e-04, 0.00016, 0.00021, 0.00027, 0.00028, 0.00029, 0.00035,
               0.00036, 0.00037, 0.00034, 0.00038, 0.00036, 0.00038, 0.00037,
               0.00044, 5e-04, 0.00051, 0.00055, 7e-04, 0.00074, 0.00076, 0.00078,
               0.00076, 7e-04, 0.00078, 0.00078, 0.00091, 0.00096, 0.00103,
               0.00112, 0.0012, 0.00138, 0.0016, 0.00192, 0.00224, 0.00266,
               0.00291, 0.00319, 0.00349, 0.00387, 0.0044, 0.00491, 0.00565,
               0.00609, 0.00673, 0.00723, 0.00778, 0.00844, 0.00952, 0.01044,
               0.01119, 0.0124, 0.01357, 0.01488, 0.01594, 0.01727, 0.01872,
               0.02029, 0.02171, 0.0237, 0.02625, 0.02818, 0.03051, 0.03323,
               0.03698, 0.04079, 0.04605, 0.05167, 0.05898, 0.06439, 0.07144,
               0.07935, 0.08765, 0.09585, 0.10583, 0.11705, 0.12861, 0.14218,
               0.15571, 0.17194, 0.18712, 0.20318, 0.21773, 0.2308, 0.24627,
               0.25896, 0.26325, 0.26827, 0.2765, 0.27272, 0.24799, 0.22936,
               0.19868, 0.17734, 0.15662, 0.15714, 0.14942, 0.12339, 0.14107,
               0.08829, 0.06772),
               nrow = 111L, ncol = 2L, dimnames = list(NULL, c("Y2021", "Y2022")))

Lx <- matrix(c(39493.05, 48856.36, 55123.06, 60751.17, 66031.82, 70946.31,
               75208.69, 79412.74, 82652.24, 85128.87, 87020.23, 88685.67,
               89705, 90517.94, 91646.01, 92918.48, 94170.36, 95460.83, 97687.18,
               100164.66, 103261.96, 106992.27, 111921.92, 116603.89, 121291.46,
               125936.06, 130752.09, 134804.76, 139320.39, 144206.5, 149682.01,
               154873.73, 160815.58, 167089.22, 173680.55, 179504.54, 184932.72,
               189330.61, 192820.72, 193978.13, 193934.13, 193179.32, 191721.7,
               188989.66, 186417.68, 184378.77, 182201.46, 180054.42, 178485.35,
               177261.95, 175410.36, 173603.62, 171631.32, 169582.45, 167628.59,
               165317.96, 162698.1, 159899.55, 156710.46, 152477.14, 148809.7,
               144888.18, 141481.5, 138641.49, 136507.83, 133596.61, 131455.18,
               129085.66, 125392.97, 120104.96, 114700.89, 107965.81, 100031.66,
               91822.18, 84574.49, 78886.03, 74100.05, 70091.95, 67604.06, 65699.18,
               62590.7, 58770.4, 54806.82, 49668.38, 43748.81, 37750.22, 31925.7,
               26140.64, 21029.01, 16690.26, 12842.08, 9656.27, 7150.16, 5130.6,
               3537.15, 2395.44, 1599.79, 1058.39, 675.82, 447.16, 308.76, 234.85,
               179.15, 157.42, 136.35, 122.47, 97.96, 88.06, 79.53, 63.62, 46.71,
               36630.78, 45891.8, 52172.94, 57352.35, 62562.67, 67386.39, 72005.75,
               76355.92, 80515.9, 83898.66, 86538.01, 88545.23, 90128.12, 91180.86,
               92148.96, 93368.73, 94695.83, 95926.17, 97595.46, 99320.7, 101814.36,
               104643.36, 108574.15, 112812.37, 117584.14, 121903.48, 126651.53,
               130739.43, 134924.59, 139100.46, 144051.46, 148808.85, 154075.99,
               159886.92, 166350.24, 172505.02, 178361.41, 183831.91, 188630.54,
               191534.35, 193004.78, 193429.58, 193222.93, 191243.25, 188992.12,
               186776.36, 184924.44, 182272.74, 180435.57, 179322.72, 177992.62,
               176083.51, 174604.92, 172917.28, 170794.39, 168626.14, 166345.52,
               163790.65, 160928.87, 157002.29, 152973.22, 149050.82, 144971.78,
               141000.87, 138484.3, 135568.46, 132464.84, 129908.86, 127041.89,
               122810.99, 117770.62, 111814.78, 105165.19, 97433.74, 89018.38,
               81824.61, 76121.28, 70589.37, 66375.32, 63833.38, 61269.47, 57992.61,
               54404.69, 50190.06, 45060.81, 39460.55, 33700.22, 27923.89, 22693.17,
               17989.68, 13907.67, 10479.36, 7768.35, 5603.56, 3927.38, 2645.58,
               1771.36, 1171.63, 751.12, 468.68, 307.32, 227.74, 167.73, 138.75,
               123.58, 105.55, 92.89, 68.44, 59.3, 54.13, 42.8),
               nrow = 111L, ncol = 2L, dimnames = list(NULL, c("Y2021", "Y2022")))

dx <- matrix(c(21, 5, 7, 6, 6, 4, 3, 2, 3, 8, 7, 15, 22, 28, 27, 32, 33, 33,
               35, 34, 36, 36, 41, 43, 55, 61, 66, 75, 95, 101, 110, 119,
               118, 124, 141, 154, 183, 203, 215, 225, 237, 275, 321, 373,
               438, 520, 557, 589, 639, 693, 770, 837, 982, 1047, 1137, 1208,
               1285, 1347, 1480, 1600, 1674, 1794, 1903, 2034, 2134, 2263,
               2433, 2623, 2712, 2845, 2980, 3004, 3041, 3057, 3104, 3242, 3502,
               3662, 4033, 4361, 4632, 4838, 5033, 5065, 4963, 4782, 4481, 4080,
               3639, 3202, 2717, 2242, 1809, 1382, 1024, 732, 489, 333, 224,
               140, 82, 54, 34, 22, 18, 17, 15, 10, 9, 6, 4, 16, 7, 6, 8, 7,
               4, 2, 3, 4, 9, 9, 14, 19, 25, 26, 27, 33, 35, 36, 34, 39, 38,
               41, 42, 52, 61, 64, 72, 95, 103, 110, 116, 117, 112, 129, 134,
               162, 177, 194, 214, 231, 268, 310, 367, 424, 498, 539, 583, 631,
               696, 785, 867, 990, 1056, 1153, 1224, 1300, 1389, 1539, 1647,
               1722, 1860, 1981, 2114, 2225, 2361, 2503, 2663, 2788, 2946, 3132,
               3196, 3258, 3292, 3354, 3407, 3588, 3744, 4034, 4247, 4539, 4792,
               4987, 5053, 5035, 4906, 4632, 4274, 3832, 3384, 2871, 2370, 1898,
               1462, 1103, 787, 537, 363, 241, 148, 87, 59, 37, 27, 21, 18,
               15, 9, 9, 5, 3),
               nrow = 111L, ncol = 2L, dimnames = list(NULL, c("Y2021", "Y2022")))

x <- list("qx" = qx, "Lx" = Lx, "dx" = dx)

example <- graduate_qx(x = x, ages = c(3, 113))

}
\references{
Sifre-Armengol, C., Pavia J.M. and Lledo, J. (2025) A comprehensive database of estimates and forecasts of Spanish sex-age death rates by climate area, income level, and habitat size (2010-2050). *Demographic Research*, 52(1): 1-24. \doi{10.4054/DemRes.2025.52.1}.
}
\author{
Jose M. Pavia \email{pavia@uv.es}
}
