% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{clusterProportions}
\alias{clusterProportions}
\title{Compute the Proportion of Items in Each Cluster for All Partitions}
\usage{
clusterProportions(partitions)
}
\arguments{
\item{partitions}{A matrix, with each row representing a set partition of the
integers \eqn{1}, ..., \eqn{n} as cluster labels}
}
\value{
A matrix whose columns represent the cumulative proportion of the
  data that correspond to that cluster.
}
\description{
Compute the Proportion of Items in Each Cluster for All Partitions
}
\examples{

# Neal (2000) model and data
nealData <- c(-1.48, -1.40, -1.16, -1.08, -1.02, 0.14, 0.51, 0.53, 0.78)
mkLogPosteriorPredictiveDensity <- function(data = nealData,
                                            sigma2 = 0.1^2,
                                            mu0 = 0,
                                            sigma02 = 1) {
  function(i, subset) {
    posteriorVariance <- 1 / ( 1/sigma02 + length(subset)/sigma2 )
    posteriorMean <- posteriorVariance * ( mu0/sigma02 + sum(data[subset])/sigma2 )
    posteriorPredictiveSD <- sqrt(posteriorVariance + sigma2)
    dnorm(data[i], posteriorMean, posteriorPredictiveSD, log=TRUE)
  }
}

logPostPredict <- mkLogPosteriorPredictiveDensity()

nSamples <- 500L
partitions <- matrix(0, nrow=nSamples, ncol=length(nealData))
for ( i in 2:nSamples ) {
  partitions[i,] <- nealAlgorithm3(partitions[i-1,], logPostPredict, mass = 1.0, nUpdates = 2)
}
clusterProportions(partitions)
}
