% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_implicates.R
\name{scf_implicates}
\alias{scf_implicates}
\title{Extract Implicate-Level Estimates from SCF Results}
\usage{
scf_implicates(x, long = FALSE)
}
\arguments{
\item{x}{A result object containing implicate-level estimates (e.g., from scf_mean, scf_ols).}

\item{long}{Logical. If TRUE, returns stacked data frame. If FALSE, returns list.}
}
\value{
A list of implicate-level data frames, or a single stacked data frame if \code{long = TRUE}.
}
\description{
Returns implicate-level outputs from SCF result objects produced by functions
in the \code{scf} suite. Supports result objects containing implicate-level data
frames, \code{svystat} summaries, or \code{svyglm} model fits.
}
\section{Usage}{

This function allows users to inspect how estimates vary across the SCF’s five implicates,
which is important for diagnostics, robustness checks, and transparent reporting.

For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{scf_implicates(scf_mean(scf2022, ~income))
scf_implicates(scf_ols(scf2022, networth ~ age + income), long = TRUE)
}\if{html}{\out{</div>}}
}

\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td  <- tempdir()
src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Example for real analysis: Extract implicate-level results
out <- scf_freq(scf2022, ~own)
scf_implicates(out, long = TRUE)

# Do not implement these lines in real analysis: Cleanup for package check
unlink("scf2022.rds", force = TRUE)

}
