% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_plot_hist.R
\name{scf_plot_hist}
\alias{scf_plot_hist}
\title{Histogram of a Continuous Variable in Multiply-Imputed SCF Data}
\usage{
scf_plot_hist(
  design,
  variable,
  bins = 30,
  xlim = NULL,
  title = NULL,
  xlab = NULL,
  ylab = "Weighted Count",
  fill = "#0072B2"
)
}
\arguments{
\item{design}{A \code{scf_mi_survey} object from \code{\link[=scf_load]{scf_load()}}.}

\item{variable}{A one-sided formula indicating the numeric variable to plot.}

\item{bins}{Number of bins (default: 30).}

\item{xlim}{Optional numeric range. Values outside will be included in edge bins.}

\item{title}{Optional plot title.}

\item{xlab}{Optional x-axis label. Defaults to the variable name.}

\item{ylab}{Optional y-axis label. Defaults to "Weighted Count".}

\item{fill}{Fill color for bars (default: \code{"#0072B2"}).}
}
\value{
A \code{ggplot2} object representing the Rubin-pooled histogram.
}
\description{
Produces a histogram of a continuous SCF variable by binning across implicates,
pooling weighted bin counts using \code{\link[=scf_freq]{scf_freq()}}, and plotting the result.
Values outside \code{xlim} are clamped into the nearest endpoint to ensure all
observations are included and replicate-weighted bins remain stable.
}
\section{Implementation}{

This function bins a continuous variable (after clamping to \code{xlim} if supplied),
applies the same \code{cut()} breaks across implicates using \code{\link[=scf_update_by_implicate]{scf_update_by_implicate()}},
and computes Rubin-pooled frequencies with \code{\link[=scf_freq]{scf_freq()}}. Results are filtered to
remove bins with undefined proportions and then plotted using \code{ggplot2::geom_col()}.

The logic here is specific to operations where the bin assignment must be computed
\strong{within} each implicate, not after pooling. This approach ensures consistent binning
and stable pooled estimation in the presence of multiply-imputed microdata.
}

\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td  <- tempdir()
src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Example for real analysis: Plot histogram of age
scf_plot_hist(scf2022, ~age, bins = 10)

# Do not implement these lines in real analysis: Cleanup for package check
unlink("scf2022.rds", force = TRUE)

}
\seealso{
\code{\link[=scf_freq]{scf_freq()}}, \code{\link[=scf_plot_dbar]{scf_plot_dbar()}}, \code{\link[=scf_plot_smooth]{scf_plot_smooth()}}, \code{\link[=scf_update_by_implicate]{scf_update_by_implicate()}}
}
