% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqtest.mean.R
\name{seqtest.mean}
\alias{seqtest.mean}
\title{Sequential triangular test for the arithmetic mean}
\usage{
seqtest.mean(x, y = NULL, mu = NULL, alternative = c("two.sided", "less", "greater"),
             sigma = NULL, delta = NULL, theta = NULL, alpha = 0.05, beta = 0.1,
             output = TRUE, plot = FALSE)
}
\arguments{
\item{x}{initial data for group x, at least one entry.}

\item{y}{initial data for group y, at least one entry for a two-sample test.}

\item{mu}{a number indicating the true value of the mean in case of the one-sample test, \eqn{\mu}.0.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "two.sided" (default), "greater" or "less".}

\item{sigma}{standard deviation in the population, \eqn{\sigma}.}

\item{delta}{absolute minimum difference to be detected, \eqn{\delta}.}

\item{theta}{relative minimum difference to be detected, \eqn{\theta}.}

\item{alpha}{type-I-risk, \eqn{\alpha}.}

\item{beta}{type-II-risk, \eqn{\beta}.}

\item{output}{logical: if \code{TRUE}, output is shown.}

\item{plot}{logical: if \code{TRUE}, a plot is generated.}
}
\value{
Returns an object of class \code{seqtest}, to be used for later update steps. The object has
following entries:

\tabular{ll}{
  \code{call}      \tab function call \cr
  \code{type}      \tab type of the test (i.e., arithmetic mean) \cr
  \code{spec}      \tab specification of function arguments \cr
  \code{tri}       \tab specification of the triangular \cr
  \code{dat}       \tab data \cr
  \code{res}       \tab list with results \cr
}
}
\description{
This function performs the sequential triangular test for the arithmetic mean
in one- or two-samples
}
\details{
For the one-sample test, arguments \code{x}, \code{mu} and the minimum difference to be detected
has to be specified (i.e., argument \code{y} must not be specified). For the two-sample test, arguments
\code{x}, \code{y}, and the minimum difference to be detected has to be specified. There are two options to specify
the minimum difference to be detected: (1) using arguments \code{mu}, \code{sigma} and \code{delta} or
(2) using arguments \code{mu} and \code{theta}.
Note that it is not a requirement to know sigma in advance, i.e., theta can be specified directly. For example,
\code{theta = 1} specifies a relative minimum difference to be detected of one standard deviation.

In order to specify a one-sided test, argument \code{alternative} has to be used (i.e., two-sided tests are conducted by default).
For the one-sample test, \code{alternative = "less"} specifies the null hypothesis, H0: \eqn{\mu} >= \eqn{\mu}.0
and the alternative hypothesis, H1: \eqn{\mu} < \eqn{\mu}.0; \code{alternative = "greater"} specifies the
null hypothesis, H0: \eqn{\mu} <= \eqn{\mu}.0 and the alternative hypothesis, H1: \eqn{\mu} > \eqn{\mu}.0.
For the two-sample test \code{alternative = "less"} specifies the null hypothesis, H0: \eqn{\mu}.1 >= \eqn{\mu}.2
and the alternative hypothesis, H1: \eqn{\mu}.1 < \eqn{\mu}.2; \code{alternative = "greater"} specifies
the null hypothesis, H0: \eqn{\mu}.1 <= \eqn{\mu}.2 and the alternative hypothesis, H1: \eqn{\mu}.1 > \eqn{\mu}.2.

The main characteristic of the sequential triangular test is that there is no fixed sample size given
in advance. That is, for the most recent sampling point, one has to decide whether
sampling has to be continued or either the null- or the alternative hypothesis can be
accepted given specified precision requirements (i.e. type-I-risk, type-II-risk and a minimum difference to be detected).
The (cumulative) test statistic \code{Z.m} on a Cartesian coordinate system produces a "sequential path"
on a continuation area as a triangle. As long as the statistic remains within that triangle,
additional data have to be sampled. If the path touches or exceeds the borderlines of the triangle,
sampling is completed. Depending on the particular borderline, the null-hypothesis is either
accepted or rejected.
}
\examples{

#--------------------------------------
# Two-sided one-sample test
# H0: mu = 50, H1: mu != 50
# alpha = 0.05, beta = 0.2, theta = 0.5

seq.obj <- seqtest.mean(56, mu = 50, theta = 0.5,
                        alpha = 0.05, beta = 0.2, plot = TRUE)

# alternative specifiation using sigma and delta
seq.obj <- seqtest.mean(56, mu = 50, sigma = 10, delta = 5,
                        alpha = 0.05, beta = 0.2, plot = TRUE)

seq.obj <- update(seq.obj, x = c(54, 52, 46, 49))
seq.obj <- update(seq.obj, x = c(46, 49, 51, 45))
seq.obj <- update(seq.obj, x = c(51, 42, 50, 53))
seq.obj <- update(seq.obj, x = c(50, 53, 49, 53))

#--------------------------------------
# One-sided one-sample test
# H0: mu <= 50, H1: mu > 50
# alpha = 0.05, beta = 0.2, theta = 0.5

seq.obj <- seqtest.mean(c(56, 53), mu = 50, alternative = "greater",
                        theta = 0.5, alpha = 0.05, beta = 0.2, plot = TRUE)

# alternative specifiation using sigma and delta
seq.obj <- seqtest.mean(c(56, 53), mu = 50, alternative = "greater",
                        sigma = 10, delta = 5, alpha = 0.05, beta = 0.2, plot = TRUE)

seq.obj <- update(seq.obj, x = c(67, 52, 48, 59))
seq.obj <- update(seq.obj, x = c(53, 57, 54, 62))
seq.obj <- update(seq.obj, x = 58)

#--------------------------------------
# Two-sided two-sample test
# H0: mu.1 = mu.2, H1: mu.1 != mu.2
# alpha = 0.01, beta = 0.1, theta = 1

seq.obj <- seqtest.mean(53, 45, theta = 1,
                        alpha = 0.01, beta = 0.01, plot = TRUE)

# alternative specifiation using sigma and delta
seq.obj <- seqtest.mean(57, 45, sigma = 10, delta = 10,
                        alpha = 0.01, beta = 0.01, plot = TRUE)

seq.obj <- update(seq.obj, x = c(58, 54, 56), y = c(45, 41, 42))
seq.obj <- update(seq.obj, x = c(56, 50, 49), y = c(42, 45, 50))
seq.obj <- update(seq.obj, x = c(62, 57, 59))
seq.obj <- update(seq.obj, y = c(41, 39, 46))
seq.obj <- update(seq.obj, x = 67)
seq.obj <- update(seq.obj, y = 40)
seq.obj <- update(seq.obj, y = 36)

#--------------------------------------
# One-sided two-sample test
# H0: mu.1 <= mu.2, H1: mu.1 > mu.2
# alpha = 0.01, beta = 0.1, theta = 1

seq.obj <- seqtest.mean(53, 45, alternative = "greater", theta = 1,
                        alpha = 0.01, beta = 0.01, plot = TRUE)

# alternative specifiation using sigma and delta
seq.obj <- seqtest.mean(57, 45, alternative = "greater",sigma = 10, delta = 10,
                        alpha = 0.01, beta = 0.01, plot = TRUE)

seq.obj <- update(seq.obj, x = c(58, 54, 56), y = c(45, 41, 42))
seq.obj <- update(seq.obj, x = c(56, 50, 49), y = c(42, 45, 50))
seq.obj <- update(seq.obj, x = c(62, 57, 59))
seq.obj <- update(seq.obj, y = c(41, 39, 46))
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
}
\references{
Rasch, D., Pilz, J., Verdooren, L. R., & Gebhardt, G. (2011).
\emph{Optimal experimental design with R}. Boca Raton: Chapman & Hall/CRC.

Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.
}
\seealso{
\code{\link{update.seqtest}}, \code{\link{seqtest.prop}}, \code{\link{seqtest.cor}},
\code{\link{print.seqtest}}, \code{\link{plot.seqtest}}, \code{\link{descript}}
}

