% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsgpower.R
\name{plotsgpower}
\alias{plotsgpower}
\title{Plot power curves for Second-Generation p-Values}
\usage{
plotsgpower(
  null.lo,
  null.hi,
  std.err,
  alt = NA,
  x.lim = NA,
  interval.type,
  interval.level = 0.05,
  plot.option = 1,
  null.col = rgb(208, 216, 232, maxColorValue = 255),
  pow.col = c("cornflowerblue", "firebrick3", "green4"),
  pow.lty = c(1, 1, 1),
  title.lab = "",
  x.lab = "Parameter",
  y.lab = "Probability",
  legend.on = TRUE,
  null.pt = NA,
  acc = 100
)
}
\arguments{
\item{null.lo}{A scalar representing the lower bound of the null interval hypothesis (indifference zone) upon which the second-generation \emph{p}-value is based.}

\item{null.hi}{A scalar representing the upper bound of the null interval hypothesis (indifference zone) upon which the second-generation \emph{p}-value is based.}

\item{std.err}{Standard error for the distribution of the estimator for the parameter of interest. Note that this is the standard deviation for the estimator, not the standard deviation parameter for the data itself. This will be a function of the sample size(s).}

\item{alt}{Optional scalar or vector of alternative value(s) for the parameter of interest. Default is \code{NA}. If provided, a blue dotted line (or one at each point) will be plotted and the power will be printed.}

\item{x.lim}{Optional numeric vector of length two giving the lower and upper bounds of the x-axis for the power curve. Default is \code{NA}, where the x-axis range will be optimized to fit the entirety of the power curve (which is dependent upon the width of the null zone and the standard error of the estimator).}

\item{interval.type}{Class of interval estimate used for calculating the SGPV. Options are \code{"confidence"} for a \eqn{(1-\alpha)100}\% confidence interval and \code{"likelihood"} for a \eqn{1/k} likelihood support interval (\code{credible} not yet supported).}

\item{interval.level}{Level of interval estimate. If \code{interval.type = "confidence"} is used, the level is \eqn{\alpha}. If \code{interval.type = "likelihood"} is used, the level is \eqn{1/k} (not \eqn{k}).}

\item{plot.option}{Used to specify the type of plot desired. If \code{plot.option = 1}, the classical power curve and its corresponding SGPV power curve are shown. If \code{plot.option = 2}, the three power curves provided by \code{sgpower} are shown. Default is \code{plot.option = 1}.}

\item{null.col}{Coloring of shading for the null interval hypothesis (indifference zone) region. Default is Hawkes Blue: \code{null.col = rgb(208, 216, 232, maxColorValue = 255)}.}

\item{pow.col}{Vector of length three specifying the colors for the the three power curves given when \code{plot.option = 2}. The first color option corresponds to the \eqn{Pr(SGPV = 0 | \theta)} line, the second color option corresponds to the \eqn{Pr(0 < SGPV < 1 | \theta)} line, and the third color option corresponds to the \eqn{Pr(SGPV = 1 | \theta)} line. Default is \code{pow.col = c("cornflowerblue", "firebrick3", "green4")}.}

\item{pow.lty}{Vector of length three specifying the line types (\code{lty}) for the three power curves given when \code{plot.option = 2}. The first line type option corresponds to the \eqn{Pr(SGPV = 0 | \theta)} line, the second line type option corresponds to the \eqn{Pr(0 < SGPV < 1 | \theta)} line, and the third line type option corresponds to the \eqn{Pr(SGPV = 1 | \theta)} line. Default is \code{pow.lty = c(1,1,1)} for solid lines.}

\item{title.lab}{Title text.}

\item{x.lab}{x-axis label.}

\item{y.lab}{y-axis label.}

\item{legend.on}{Toggle for plotting the legend. Default is \code{TRUE}.}

\item{null.pt}{Optional numeric scalar representing a point null hypothesis. Default is \code{NA}. If a value is given, it will be plotted as a black dashed line and the type I error at that point will be printed.}

\item{acc}{Optional parameter specifying the resolution of the x-axis. Default is \code{acc = 100} for plotting the power curve as a sequence of 100 (x, y) points.}
}
\description{
This function calculates power and type I error values from significance testing based on second-generation p-values as the inferential metric and plots the power curve to visualize the operating charateristics of the inferential procedure.
}
\examples{

sigma = 5
n = 20

plotsgpower(alt = NA, null.lo = -1, null.hi = 1,
            std.err = sigma/sqrt(n), x.lim = c(-8,8),
           interval.type = 'confidence', interval.level = 0.05,
           plot.option = 2, null.pt = 0)

plotsgpower(alt = c(-4,2),
            null.lo = -1, null.hi = 1, std.err = sigma/sqrt(n),
            x.lim = NA, interval.type = 'confidence',
            interval.level = 0.05, plot.option = 2)

plotsgpower(alt = NA, null.lo = -1, null.hi = 1,
            std.err = sigma/sqrt(n), x.lim = NA,
            interval.type = 'confidence', interval.level = 0.05,
            plot.option = 1, null.pt = NA)

plotsgpower(alt = c(-4,2), null.lo = -1, null.hi = 1,
            std.err = 1, x.lim = NA, interval.type = 'likelihood',
            interval.level = 0.05, plot.option = 1, null.pt = 0)


}
\references{
Blume JD, Greevy RA Jr., Welty VF, Smith JR, Dupont WD (2019). An Introduction to Second-generation \emph{p}-values. \emph{The American Statistician}. 73:sup1, 157-167, DOI: https://doi.org/10.1080/00031305.2018.1537893

Blume JD, D’Agostino McGowan L, Dupont WD, Greevy RA Jr. (2018). Second-generation \emph{p}-values: Improved rigor, reproducibility, & transparency in statistical analyses. \emph{PLoS ONE} 13(3): e0188299. https://doi.org/10.1371/journal.pone.0188299
}
\seealso{
\code{\link{fdrisk}, \link{sgpvalue}, \link{plotsgpv}}
}
