% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topology_functions.R
\name{calculate_thresholds}
\alias{calculate_thresholds}
\title{Calculate multiple threshold methods for topology analysis}
\usage{
calculate_thresholds(data)
}
\arguments{
\item{data}{Numeric vector to calculate thresholds for}
}
\value{
A named \code{list} containing five threshold values:
\describe{
\item{mean_diff}{Numeric. Threshold based on mean of absolute differences
between adjacent sorted values.}
\item{median_diff}{Numeric. Threshold based on median of absolute differences
between adjacent sorted values.}
\item{sd}{Numeric. Threshold based on standard deviation of the data.}
\item{iqr}{Numeric. Threshold based on IQR divided by 4.}
\item{dbscan}{Numeric. Threshold based on DBSCAN-like density estimation
using k-th nearest neighbor distance.}
}
}
\description{
Calculate multiple threshold methods for topology analysis
}
