% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Draw_ROC_macro.R
\name{Draw_ROC_curve_macro}
\alias{Draw_ROC_curve_macro}
\title{Draws multi-class ROC curve macro}
\usage{
Draw_ROC_curve_macro(pred_tensor, label_tensor)
}
\arguments{
\item{pred_tensor}{output of the model assuming it is of dimension NxK
(or Nx1 for binary classification)}

\item{label_tensor}{true labels , tensor of length N}
}
\value{
K ROC curves
}
\description{
This function draws K ROC curves  using OvR approach, each time
considering one class as the positive class.
It assumes that all the inputs are torch tensors and labels are
in [1,K] with K being the number of classes.
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Small example with 3 classes and 10 samples
set.seed(1)
labels = torch::torch_randint(1, 4, size = 10, dtype = torch::torch_long())
Draw_ROC_curve_micro(torch::torch_randn(c(10, 3)), labels)
}
\dontshow{\}) # examplesIf}
}
