% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-messages.R
\name{http-messages}
\alias{http-messages}
\alias{http_error}
\alias{http_success}
\alias{http_response}
\alias{http_handler}
\title{Generic HTTP Response Messages}
\usage{
http_error(status = 500L, message = NULL)

http_success(status = 200L, message = NULL, body = NULL)

http_response(status = 200L, message = NULL, body = NULL)

http_handler(req, res, status = 200L, message = NULL, body = NULL)
}
\arguments{
\item{status}{HTTP status code.}

\item{message}{An HTTP response message or \code{NULL}.
A generic response message is provided when it is \code{NULL}
based on \code{\link{http_status_codes}}.}

\item{body}{A list, additional values to be returned.}

\item{req}{The request object.}

\item{res}{The response object.}
}
\value{
\code{http_error} returns an error with a custom condition attribute
after checking if the status code is at least 400.

\code{http_success} returns a list but checks that the status code is <400.

\code{http_response} returns a list checking only that the status code is valid.

\code{http_handler} behaves like \code{http_response} but it also sets the status code
and the body of the response object.
}
\description{
These functions provide generic HTTP response messages
based on the HTTP response status codes.
}
\examples{
try(http_error())
try(http_error(400))
try(http_error(400, "Sorry"))

str(http_success())
str(http_success(201))
str(http_success(201, "Awesome"))

str(http_response(201, "Awesome", list(name = "Jane", count = 6)))

req <- new.env()
res <- new.env()
str(http_handler(req, res, 201, "Awesome", list(name = "Jane", count = 6)))
res$status
str(res$body)


}
\seealso{
\code{\link{http_status_codes}}
}
