% Generated by roxygen2 (4.0.2): do not edit by hand
\name{matchNone}
\alias{matchNone}
\title{Return a Symbol That Matches No Values}
\usage{
matchNone(x, table = list(c(".", "!", "/"), c("NA", "na")))
}
\arguments{
\item{x}{A vector or matrix.}

\item{table}{The lookup table against which to seek non-matches.
This can be a simple vector, or it can be a list of
two vectors.}
}
\value{
A string composed of the strings in the \code{table}.
  The default list choses the first non-matching value
  out of 179 values that are unlikely to be used in
  most real sets of data.
  If only \code{table} is specified, the possible
  values for a non-matching string, ordered from the
  most to the least preferable, are returned.
}
\description{
The tag value is chosen from among special characters so
  that it does not appear anywhere in the reference input data.
  The shortest possible tag is chosen.
}
\details{
This function is used in other packages by the same author
  to extend missing data handling in R. It provides for
  flexible missing data identifiers where needed by an
  S4 class, and similar unmatched identifiers for other
  dirty data problems.
}
\examples{
my.x <- c(1,2,3,2,3,1,2)
matchNone(my.x)
matchNone(c(my.x,"."))
matchNone(c(my.x,".","!"))
matchNone(c(my.x,".","!","/"))
matchNone(c(my.x,".","!","/",".."))
matchNone(table = ".")
}

