% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joins.R
\name{extract_joins}
\alias{extract_joins}
\title{Extract Tableau join clauses from \verb{<relation type="join">} nodes}
\usage{
extract_joins(xml_doc)
}
\arguments{
\item{xml_doc}{An \code{xml2} document for a Tableau \code{.twb}.}
}
\value{
A tibble with columns:
\describe{
\item{join_type}{Join kind (e.g., \code{inner}, \code{left}), if available.}
\item{left_table}{Left table name (cleaned).}
\item{left_field}{Left field name.}
\item{operator}{Predicate operator (defaults to \code{"="} when missing).}
\item{right_table}{Right table name (cleaned).}
\item{right_field}{Right field name.}
}
}
\description{
Handles both column-based clauses (\verb{<clause><column/></clause>}) and
expression-based predicates (\verb{<expression op=...>}) found in TWB XML.
}
\examples{

twb <- system.file("extdata", "test_for_wenjie.twb", package = "twbparser")
stopifnot(nzchar(twb), file.exists(twb))
xml <- xml2::read_xml(twb)
extract_joins(xml)


}
