% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fields.R
\name{infer_implicit_relationships}
\alias{infer_implicit_relationships}
\title{Infer implicit relationships between tables from field metadata}
\usage{
infer_implicit_relationships(fields_df, max_pairs = 50000L)
}
\arguments{
\item{fields_df}{A data frame like the output of
\code{\link[=extract_columns_with_table_source]{extract_columns_with_table_source()}}.}

\item{max_pairs}{Maximum number of candidate pairs to return (default 50,000).}
}
\value{
A tibble with columns:
\describe{
\item{left_table}{Left table name.}
\item{left_field}{Left field name.}
\item{right_table}{Right table name.}
\item{right_field}{Right field name.}
\item{reason}{Why the pair was suggested.}
}
}
\description{
Generates candidate join pairs by:
\itemize{
\item Matching \code{semantic_role} across different tables.
\item Matching field names (case-insensitive) across different tables.
}
}
\examples{
twb <- system.file("extdata", "test_for_wenjie.twb", package = "twbparser")
stopifnot(nzchar(twb), file.exists(twb))
xml <- xml2::read_xml(twb)
fields <- extract_columns_with_table_source(xml)
inferred <- infer_implicit_relationships(fields)
head(inferred)


}
