% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progression_sources.r
\name{progression}
\alias{progression}
\title{general progression function}
\usage{
progression(vfseries, method = c("plr.nouri.2012", "vfi", "schell2014",
  "cigts"))
}
\arguments{
\item{vfseries}{is a data frame. MUST contain the following columns: yearsfollowed', and 'eyeid'. Rows represent the single measurements. Other requirements, such as number of minimum measurements (rows), and necessary VF measurements could be found in each progression method's documentation}

\item{method}{selected from one or more from: plr.nouri.2012, vfi, schell2014, cigts. Default it ...}
}
\value{
"stable", "worsening", or "improving" of measurements in \code{measmatrix}
}
\description{
\code{progression} returns the progression criterion with four methods. plr.nouri.2012, vfi, schell2014, cigts
}
\examples{
data(vfseries)
progression(vfseries)
progression(vfseries[vfseries$eyeid == 1,])
progression(vfseries[vfseries$eyeid == 2,])
progression(vfseries, method=c("cigts"))
}
\seealso{
\url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4495761/}
}
