% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune.R
\name{prune}
\alias{prune}
\title{Prune the vistla tree}
\usage{
prune(x, targets, iomin, score)
}
\arguments{
\item{x}{vistla object or a vistla_hierarchy object.}

\item{targets}{a character vector of features.
When not missing, all branches not on lying paths to these targets are pruned.
Unreachable targets are ignored, while names not present in the analysed set cause an error.}

\item{iomin}{a legacy name for score, valid only for vistla objects; passing a value to either of them works the same, but giving some values for both is an error.}

\item{score}{a score threshold below which branches should be removed.
When given, it effectively overrides the value of \code{iomin} or \code{ensemble(prune,...)} given to the \code{vistla} invocation; to this end, it can only be higher then the original value, since prune only modifies the output and cannot re-run the pathfinding.}
}
\value{
Pruned \code{x}; if both arguments are missing, this function still removes suboptimal branches.
}
\description{
This function allows to filter out suboptimal branches, as well as weak ones or these not in particular paths of interest.
}
\examples{
\dontrun{
 data(chain)
 v<-vistla(Y~.,data=chain)
 print(v)
 print(prune(v,targets="M3"))
 print(prune(v,score=0.3))
}
}
